% Code for: Capital Reallocation and Aggregate Productivity
% R. Cooper & I. Schott
% Code version: September 2022

% Create Figure 3

%% Load results 
PIGRID          = readmatrix(sprintf('%s/PIGRID.csv',PARMS.figfolder));
pi_ss           = readmatrix(sprintf('%s/pi_ss.csv',PARMS.figfolder));
dSR_dPI_ss      = readmatrix(sprintf('%s/dSR_dPI_ss.csv',PARMS.figfolder));
dSR_dPI_vec     = readmatrix(sprintf('%s/dSR_dPI_vec.csv',PARMS.figfolder));

%% Make graph

close all
figure(1)
plot(PIGRID,dSR_dPI_vec,'color',rgb('lightblue'),'LineWidth',4.5)
set(gca,'FontSize',15,'TickLabelInterpreter', 'latex')
xlabel('$\pi$','Interpreter','latex','FontSize',20)
ylabel('Marginal effect on $\tilde A$','Interpreter','latex','FontSize',20)
hold on
plot(pi_ss,dSR_dPI_ss,'r*','MarkerSize',20,'Linewidth',3)

%% Clean up

clear d* pi_ss PI*